AC_DEFUN([PATH_RPMDIR],[   
# Find out the RPM source directory path

RPMSOURCESDIR="NOT-FOUND"

if test $RPM_MAJOR_VERSION -eq 3; then
             if test  $RPM_PATCH_LEVEL -ge 3 ; then 
               RPMSOURCESDIR=`rpm --eval=%_topdir`   
             fi  
   else
         if test $RPM_MAJOR_VERSION -gt 3 ; then
                RPMSOURCESDIR=`rpm --eval=%_topdir` 
         fi 
fi  

if test $RPMSOURCESDIR = "NOT-FOUND"; then 
          for directory in packages OpenLinux redhat RedHat rpm RPM "" ; do
            test -d /usr/src/${directory}/SOURCES  && RPMSOURCESDIR="/usr/src/${directory}"
          done
fi

WHOAMI=`whoami`
if test $RPMSOURCESDIR = "NOT-FOUND"; then   
            test -d /$WHOAMI/rpmbuild/SOURCES  && RPMSOURCESDIR="/$WHOAMI/rpmbuild" 
fi

if test $RPMSOURCESDIR = "NOT-FOUND"; then   
            test -d /root/rpmbuild/SOURCES  && RPMSOURCESDIR="/root/rpmbuild" 
fi

if  test ! -d "$RPMSOURCESDIR/SOURCES" ; then
   AC_MSG_WARN([RPM has no SOURCES directory. Please write the path to the RPM source directory tree])
fi

#echo RPMDIR=$RPMSOURCESDIR

RPMDIR=$RPMSOURCESDIR
AC_SUBST(RPMDIR)
])

#########3
AC_DEFUN([VERSION_RPM],[
# Verify that we have the rpm command in our path
# de checkinstall  v1.6.1  Copyright (C) 2004 Felipe Eduardo Sanchez Diaz Duran <izto@asic-linux.com.mx>


# Identify the rpm version
RPM_VERSION=`rpm --version |  cut -f3 -d" "`
RPM_MAJOR_VERSION=`echo $RPM_VERSION | cut -f1 -d"."`
RPM_MINOR_VERSION=`echo $RPM_VERSION | cut -f2 -d"."`
RPM_PATCH_LEVEL=`echo $RPM_VERSION | cut -f3 -d"."`

if test "x$RPM_PATCH_LEVEL" = "x" ; then 
   RPM_PATCH_LEVEL=0
fi

if test "$RPM_MAJOR_VERSION" = "" ; then 
   RPM_MAJOR_VERSION=1
fi

# AFAIK, the only rpm versions that accept
# "--target=arch" instead of "--target arch"
# are 3.x < version < 4.0.3

echo "rpm version, major: $RPM_MAJOR_VERSION, minor: $RPM_MINOR_VERSION, patch: $RPM_PATCH_LEVEL "

#$RPM_MAJOR_VERSION
if test  $RPM_MAJOR_VERSION -gt 4 ; then
   if test  $RPM_PATCH_LEVEL -lt 3 ; then
      RPM_TARGET_FLAG="--target="
    else
      RPM_TARGET_FLAG="--target "
   fi
else
   RPM_TARGET_FLAG="--target "
fi

# rpmbuild seems to exist only in RPM 4
RPMBUILD=
if test $RPM_MAJOR_VERSION -gt 3 ; then
   RPMBUILD="rpmbuild"
else
   RPMBUILD="rpm"
fi

AC_SUBST(RPMBUILD)
])


#############################################33
AC_DEFUN([TEST_PROG_RPM],[
       # si no estan no se puede procesar, pero igual los ponemos para definir dependencias
       PROG_FIND([RPMPATH],[rpm],[rpm],[$1])
       echo RPMPATH $RPMPATH
       #RPM_PATH=`which rpm 2> /dev/null`
       #con el anterior ya establece que este paquete depende de rpm
       if test -x "$RPMPATH"; then
          VERSION_RPM
	     if test $RPM_MAJOR_VERSION -gt 3; then
	        if test "$RPMBUILD" = "rpmbuild" -a -x "`which rpmbuild 2> /dev/null`" ; then
		      PATH_RPMDIR 
   	         else
   		       #No esta rpmbuild, solo en versiones de 4 o mas, hacer upgrade a rpm 4 o 5
                       #En fedora rmpbuild esta en paquete separado rpmbuild 
                       #en realidad necesita rpmbuild pero solo en fedora es rpm-build otro paquete
		       PROG_ALERT([rpm],[$1])
		fi
               else
		PROG_ALERT([rpm],[$1])
             fi
       fi
       # mejorar la pregunta triple
       ])
